package com.burhanstore.neonbubblequest.Utils.adapter

import android.app.Activity
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.burhanstore.neonbubblequest.R
import com.burhanstore.neonbubblequest.Utils.AppString.formatDate
import com.burhanstore.neonbubblequest.Utils.model.DB_Track

class TrackAdapter(
    private val activity: Activity,
    private val trackList: List<DB_Track>,
    private val onItemClick: (DB_Track) -> Unit
) : RecyclerView.Adapter<TrackAdapter.TrackViewHolder>() {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): TrackViewHolder {
        val view = LayoutInflater.from(activity).inflate(R.layout.item_track, parent, false)
        return TrackViewHolder(view)
    }

    override fun onBindViewHolder(holder: TrackViewHolder, position: Int) {
        val item = trackList[position]

        holder.title.text = "Read Article & Earn +${item.reward} Coins"

        Log.d("TrackAdapter", "Binding item at position $position: created_at = ${item.created_at}")
        val formattedDate = formatDate(item.created_at)
        holder.crData.text = formattedDate

    }

    override fun getItemCount(): Int = trackList.size

    inner class TrackViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        val title: TextView = itemView.findViewById(R.id.trackTitle)
        val crData: TextView = itemView.findViewById(R.id.crData)
    }
}
